﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls.Survey
{
    public partial class SurveyQuestionMultipleChoice : System.Web.UI.UserControl
    {
        public List<SURVEY_RESULTS> Questions { get; set; }
        public List<SURVEY_RESULTS> Results { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public void BuildQuestion()
        {
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER)))
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER) + ") " + AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);
            else
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);

            rblChoices.ID = "rbl" + stdQuestion.ID.ToString();

            foreach (SURVEY_RESULTS question in Questions)
            {
                if (question.STD_QUESTION_CHOICE != null)
                {
                    ListItem li = new ListItem(AntiXssEnc.Encoder.HtmlEncode(question.STD_QUESTION_CHOICE.CHOICE_TEXT), AntiXssEnc.Encoder.HtmlEncode(question.SURVEY_RESULT_ID.ToString()));

                    if (!Page.IsPostBack)
                    {
                        li.Selected = question.SELECTED_FLAG;
                    }
                    else
                    {
                        if (Request != null && Request.Form != null && Request.Form["ctl00$MainContent$" + rblChoices.ID] != null)
                        {
                            if (Request.Form["ctl00$MainContent$" + rblChoices.ID].ToString() == li.Value)
                                li.Selected = true;
                        }
                    }

                    rblChoices.Items.Add(li);
                }
            }
        }

        public string BuildNoteTemplate()
        {
            StringBuilder sbNote = new StringBuilder();

            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            /*Display all possible choices*/
            //sbNote.Append("(");
            //int count = 0;
            //foreach (SURVEY_RESULTS question in Questions)
            //{
            //    if (question.STD_QUESTION_CHOICE != null)
            //    {
            //        string strChoice = question.STD_QUESTION_CHOICE.CHOICE_TEXT;
            //        if (count != 0)
            //        {
            //            sbNote.Append(", ");
            //        }
            //        sbNote.Append(strChoice);

            //        var lblChoice = new Label();
            //        lblChoice.Text = question.STD_QUESTION_CHOICE.CHOICE_TEXT;

            //        count++;
            //    }
            //}
            //sbNote.AppendLine(")");

            if (!string.IsNullOrEmpty(stdQuestion.QUESTION_NUMBER))
            {
                string strQuestion = stdQuestion.QUESTION_NUMBER + ") " + stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }
            else
            {
                string strQuestion = stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }

            foreach (SURVEY_RESULTS question in Questions)
            {
                if (question.STD_QUESTION_CHOICE != null)
                {
                    if (question.SELECTED_FLAG)
                    {
                        sbNote.Append("- " + question.STD_QUESTION_CHOICE.CHOICE_TEXT);
                    }
                }
            }
            sbNote.AppendLine();

            return sbNote.ToString();
        }

        public void SaveQuestion()
        {
            foreach (ListItem li in rblChoices.Items)
            {
                int resultId = 0;
                if (int.TryParse(li.Value, out resultId))
                {
                    foreach (SURVEY_RESULTS result in Results)
                    {
                        if (result.SURVEY_RESULT_ID == resultId)
                            result.SELECTED_FLAG = li.Selected;
                    }
                }
            }
        }
    }
}